function xdot = peridetecting_derivative(t, x)

global M n nn nnn u0 gamma;
global m_u_bar m_o_bar f_bar J_bar epsilon;
global m_nominal f_unknown;
global a b c;
global beta0 alpha0;
global w;

%%%
alpha=0.01;
beta=2.0;
% mu=0.5;
% u=20;
mu=0.1;
u=70;

if t>15
    a = 1/2;
    b = 2/5;
    c = sqrt(3)/2;
end

%%%

z = zeros(nnn, M+1);
zdot = zeros(nnn, M+1);
grad_g = zeros(n, M);

for i=1:M+1,
  z(:, i) = x(nnn*(i-1)+1:nnn*i);
end;

%%%%%
% target
tar=z(1:2,M+1);
% tar_dot(1)=0.05+0.1*sin(1*t);
% tar_dot(2)=1.9*sin(0.25*t);
% tar_dot(1)=0;
% tar_dot(2)=0;

tar_dot(1)=0.25;
tar_dot(2)=sin(0.25*t);

% %%% J1
% % First agent
% grad_g(:, 1) = (norm(z(1:n, 1) - tar)^2 - a^2)*(z(1:n, 1) - tar) - ...
% w*gf(z(1:n, 1) - z(1:n, 2), c) - ...
% w*gf(z(1:n, 1) - z(1:n, 3), c);
% 
% % Second agent
% grad_g(:, 2) = (norm(z(1:n, 2) - tar)^2 - a^2)*(z(1:n, 2) - tar) - ...
% w*gf(z(1:n, 2) - z(1:n, 1), c) - ...
% w*gf(z(1:n, 2) - z(1:n, 3), c);
% 
% % Third agent
% grad_g(:, 3) = (norm(z(1:n, 3) - tar)^2 - a^2)*(z(1:n, 3) - tar) - ...
% w*gf(z(1:n, 3) - z(1:n, 1), c) - ...
% w*gf(z(1:n, 3) - z(1:n, 2), c);

%%% J2
% First agent
grad_g(:, 1) = (norm(z(1:n, 1) - tar)^2 - a^2)*(z(1:n, 1) - tar) + ...
   w*(norm(z(1:n, 1) - z(1:n, 2))^2 - c^2)*(z(1:n, 1) - z(1:n, 2)) + ... 
   w*(norm(z(1:n, 1) - z(1:n, 3))^2 - c^2)*(z(1:n, 1) - z(1:n, 3)); 

% Second agent
grad_g(:, 2) = (norm(z(1:n, 2) - tar)^2 - a^2)*(z(1:n, 2) - tar) + ...
   w*(norm(z(1:n, 2) - z(1:n, 1))^2 - c^2)*(z(1:n, 2) - z(1:n, 1)) + ... 
   w*(norm(z(1:n, 2) - z(1:n, 3))^2 - c^2)*(z(1:n, 2) - z(1:n, 3));

% Third agent
grad_g(:, 3) = (norm(z(1:n, 3) - tar)^2 - a^2)*(z(1:n, 3) - tar) + ...
   w*(norm(z(1:n, 3) - z(1:n, 1))^2 - c^2)*(z(1:n, 3) - z(1:n, 1)) + ... 
   w*(norm(z(1:n, 3) - z(1:n, 2))^2 - c^2)*(z(1:n, 3) - z(1:n, 2));

% %%% Without any formation
% grad_g(:, 1) = (z(1:n, 1) - tar);
% grad_g(:, 2) = (z(1:n, 2) - tar);
% grad_g(:, 3) = (z(1:n, 3) - tar);
%%%%

%%% 
for i=1:M
  zdot(1:n, i) = z(n+1:nn, i); 
  
% filter
zf=z(nn+1:nnn, i);
zf_dot = -zf/mu+beta*[sign(grad_g(:, i))]/mu;
zdot(nn+1:nnn, i) = zf_dot;
sn=zdot(1:n, i)+alpha*(grad_g(:, i))+zf(1:n);
zdot(n+1:nn, i)= -u*tanh(10*sn)-sin(0.2*t);

end;
%%% 

% Calculate the controller gain
%mxd = calculate_maxdist(z,M);
%alpha = M*(a*mxd + b*sqrt(c/2)*exp(-1/2));
%J_bar = 0.01*M*beta0*(alpha0 + alpha);
%u0 = (1/m_u_bar)*(m_o_bar*f_bar + J_bar + epsilon);

% if M>1
% for i=2:M,
%   zdot(1:n, i) = z(n+1:nn, i);
% %   for j=1:M,
% %     if (j ~= i),
% %       grad_g(:, i) = grad_g(:, i) + g(z(1:n, i) - z(1:n, j));
% %     end;
% %   end;
%   s = (zdot(1:n, i) - grad_g(:, i));
%   %zdot(n+1:nn, i) = (1/m_nominal)*(-u0*sign(s) - f_unknown*sin(0.2*t));
%   zdot(n+1:nn, i) = (1/m_nominal)*(-u0*tanh(gamma*s) - f_unknown*sin(0.2*t));
% end;
% end

%%%
zdot(1:n, M+1) = tar_dot(:);
%%%

% Return a column vector
for i=1:M+1,
  xdot(nnn*(i-1)+1:nnn*i) = zdot(:, i);
end;
xdot = xdot';  %'

%%% Attraction/Repulsion Function g(.) to be used above
function gout = gf(y, d)

% % Linear attraction and unbounded repulsion
% %gout = - y.*(d*d - (1/(norm(y))^2));
% 
% Linear attraction and exponential repulsion
b = 20; c = 0.2;
a = b*exp(-d*d/c);
gout = - y.*(a - b*exp(-(norm(y)^2)/c));

% Linear attraction and constant repulsion
%gout = -y.*(d - 1/(norm(y)));



%%% Attraction/Repulsion Function g(.) to be used above
function gout = g(y)

% Linear attraction and exponential repulsion
gout = g_lin_exp(y);

% Linear attraction and constant repulsion
%gout = g_lin_const(y);

% Linear attraction and exponential repulsion with saturation
%gout = g_lin_exp_sat(y);

% Exponential attraction and exponential repulsion
%gout = g_exp_exp(y);

% Exponential attraction and hardlimiting repulsion
%gout = g_exp_hl(y);

% Exponential attraction and hardlimiting repulsion with even drift term
%gout = g_exp_hl_even(y);

% Linear attraction and hardlimiting2 repulsion
%gout = g_lin_hl2(y);

% Linear attraction and hardlimiting3 repulsion
%gout = g_lin_hl3(y);

% Hardlimiting attraction/repulsion
%gout = g_hl_ar(y);